/*
 * Decompiled with CFR 0.152.
 */
package com.roguewave.chart.overlay.overlays.v2_1;

import com.roguewave.chart.core.v2_1.ChartGraphics;
import com.roguewave.chart.core.v2_1.DataModel;
import com.roguewave.chart.core.v2_1.graphics.Drawable;
import com.roguewave.chart.drawables.device.v2_1.DeviceText;
import com.roguewave.chart.overlay.core.v2_1.ChartOverlay;
import com.roguewave.chart.overlay.core.v2_1.ParameterCalculator;
import com.roguewave.chart.richtext.v2_1.AlignedBlock;
import com.roguewave.chart.richtext.v2_1.HTMLStyleParser;
import com.roguewave.chart.richtext.v2_1.TextBlock;
import com.roguewave.chart.richtext.v2_1.TextBlockDrawable;
import java.awt.Color;
import java.awt.Font;

public class BinScaleOverlay
implements ChartOverlay {
    int firstLabel_;
    int labelPeriod_;
    Color labelColor_;
    Font labelFont_;

    public BinScaleOverlay(int firstLabel, int labelPeriod, Color color, Font font) {
        this.firstLabel_ = firstLabel;
        this.labelPeriod_ = labelPeriod;
        this.labelColor_ = color;
        this.labelFont_ = font;
    }

    public void setLabelParameters(int firstLabel, int labelPeriod) {
        this.firstLabel_ = firstLabel;
        this.labelPeriod_ = labelPeriod;
    }

    public void setFirstLabel(int firstLabel) {
        this.firstLabel_ = firstLabel;
    }

    public void setLabelPeriod(int labelPeriod) {
        this.labelPeriod_ = labelPeriod;
    }

    public int getItemWidth() {
        return 0;
    }

    public void addTo(ChartGraphics chartGraphics, DataModel data, int base, int left, int right, int offset, int columnWidth, ParameterCalculator params1, ParameterCalculator params2) {
        left += offset;
        base += 2;
        int columnCount = data.getColumnCount();
        int labelCount = 0;
        for (int i = this.firstLabel_; i < columnCount; i += this.labelPeriod_) {
            Drawable label;
            ++labelCount;
            String text = data.getColumnLabel(i);
            int lx = left + i * columnWidth;
            if (text.indexOf(60) != -1) {
                TextBlock block = HTMLStyleParser.parse(text, null);
                block = new AlignedBlock(block, 1);
                label = new TextBlockDrawable(block, lx, base, 0);
            } else {
                label = new DeviceText(text, lx, base, 0, this.labelColor_, this.labelFont_);
            }
            chartGraphics.add2DDrawable(label);
        }
    }
}

